<?php

namespace RtRasel\LaravelInstaller\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use RtRasel\LaravelInstaller\Constants\Installer;
use RtRasel\LaravelInstaller\Helpers\LicenseManager;
use RtRasel\LaravelInstaller\Helpers\DatabaseManager;
use RtRasel\LaravelInstaller\Helpers\InstalledFileManager;

class UpdateController extends Controller
{
    /**
     * @var LicenseManager
     */
    protected $LicenseManager;

    /**
     * @param  LicenseManager  $licenseManager
     */
    public function __construct(LicenseManager $licenseManager)
    {
        $this->LicenseManager = $licenseManager;
    }

    /**
     * Display the updater welcome page.
     *
     * @return \Illuminate\View\View
     */
    public function welcome()
    {
        $updateData = $this->LicenseManager->check_update();

        return view('laravelinstaller::update.welcome', compact('updateData'));
    }

    /**
     * Install Update
     * 
     * @param  Request  $request
     * @return \Illuminate\View\View
     */
    public function install(Request $request, DatabaseManager $databaseManager, InstalledFileManager $fileManager)
    {
        $rules = Installer::CONFIG['update']['form']['rules'];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(['status' => 'error', 'message' => __('Something went wrong.')]);
        }

        $response = $this->LicenseManager->download_update($request->update_id, $request->has_sql, $request->version);
        if(isset($response) && $response['status'] === 'success'){
            $databaseManager->migrateOnly();
            $fileManager->update();
        }
        
        return response()->json($response);
    }
}
