@extends('layouts.app')

@section('title')
    {{ $settings->home_title }}
@endsection

@section('content')

 <!--- products --->
          <section class="my-2" id="topup">
                <div class="container mx-auto">
                    
                  <div class="pb-1 md:pb-10">
                    <div class="md:py-5 md:px-0 grid md:grid-cols-6 sm:grid-cols-4 grid-cols-3 md:gap-8 gap-4">
            @foreach ($products as $product)
 <div class="single-game-product mb-2 md:mb-6">
                        <a href="{{ route('topup', ['slug' => $product->slug]) }}" class="triangle">
                          <div class="cursor-pointer">
                            <div class="inset-0 opacity-25"></div>
                            <div class="inset-0 transform hover:scale-90 transition duration-300">
                              <div class="h-full w-full text-center mx-auto">
                                <img src="{{ $product->image_url }}" width="200" height="100" alt="" data-nuxt-img="" sizes="(max-width: 640px) 100vw, (max-width: 768px) 50vw, 400px" srcset="{{ $product->image_url }} 1w, {{ $product->image_url }} 2w, {{ $product->image_url }} 320w, {{ $product->image_url }} 400w, {{ $product->image_url }} 640w, {{ $product->image_url }} 800w" class="rounded-md">
                              </div>
                            </div>
                          </div>
                          <div>
                            <h1 class="capitalize text-xs text-center pt-3 font-primary font-extralight text-secondary-500">{{ $product->title }}</h1>
                          </div>
                        </a>
                      </div>
            @endforeach
                    </div>
                  </div>
              </div>
           </section>


@endsection
